////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN

@class PasswordError;

/**
 * <p>The {@link ChangePasswordDelegate} protocol defines the specific elements required for the
 * integrator to interact during the Change Password flow.</p>
 */
NS_REFINED_FOR_SWIFT
@protocol ChangePasswordDelegate <NSObject>

/**
 * Called upon change password success
 */
- (void)onChangePasswordSuccess;

/**
 * Called upon change password abortion
 */
- (void)onChangePasswordAborted;

/**
 * Called upon change password error
 */
- (void)onChangePasswordInputError:(PasswordError *)error;

/**
 * Called when an authentication validation request command is ready to be sent to the server
 * for verification.
 *
 * @param command This command contains an OTP generated
 */
- (void)onChangePasswordStepComplete:(NSString *)command;

@end

NS_ASSUME_NONNULL_END
